/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class WidgetNumberField
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowUp;
    private ButtonArrow arrowDown;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private boolean isEnabled = true;

    public WidgetNumberField(Font fontrenderer, int x, int y, int width, int height, boolean arrows, Component narrationMessage, boolean background) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowUp = new ButtonArrow(x, y + height / 2, (Component)new TranslatableComponent("gui.cyclopscore.up"), button -> this.increase(), ButtonArrow.Direction.NORTH);
            this.arrowDown = new ButtonArrow(x, y + height / 2, (Component)new TranslatableComponent("gui.cyclopscore.down"), button -> this.decrease(), ButtonArrow.Direction.SOUTH);
            this.arrowUp.f_93621_ -= this.arrowUp.m_93694_();
        }
        this.m_94182_(true);
        this.m_94144_("0");
    }

    public void m_94186_(boolean enabled) {
        this.arrowUp.f_93623_ = enabled;
        this.arrowDown.f_93623_ = enabled;
        this.isEnabled = enabled;
        super.m_94186_(enabled);
    }

    public boolean m_94219_() {
        return false;
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.setMinValue(positiveOnly ? 0 : Integer.MIN_VALUE);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
        this.updateArrowsState();
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getInt() throws NumberFormatException {
        return this.validateNumber(Integer.parseInt(this.m_94155_()));
    }

    public double getDouble() throws NumberFormatException {
        return this.validateNumber(Double.parseDouble(this.m_94155_()));
    }

    public float getFloat() throws NumberFormatException {
        return this.validateNumber(Float.parseFloat(this.m_94155_()));
    }

    @Override
    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowUp.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
            this.arrowDown.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
            offsetX = this.arrowUp.m_5711_();
            this.f_93620_ += offsetX;
            this.f_93618_ -= offsetX;
        }
        super.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.f_93620_ -= offsetX;
            this.f_93618_ += offsetX;
        }
    }

    public int validateNumber(int number) {
        return Math.max(this.minValue, Math.min(this.maxValue, number));
    }

    public double validateNumber(double number) {
        return Math.max((double)this.minValue, Math.min((double)this.maxValue, number));
    }

    public float validateNumber(float number) {
        return Math.max((float)this.minValue, Math.min((float)this.maxValue, number));
    }

    protected int getDiffAmount() {
        return MinecraftHelpers.isShifted() ? 10 : 1;
    }

    protected void increase() {
        try {
            this.m_94144_(Integer.toString(this.validateNumber(this.getInt() + this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.m_94144_("0");
        }
        this.updateArrowsState();
    }

    protected void decrease() {
        try {
            this.m_94144_(Integer.toString(this.validateNumber(this.getInt() - this.getDiffAmount())));
        }
        catch (NumberFormatException e) {
            this.m_94144_("0");
        }
        this.updateArrowsState();
    }

    @Override
    public void m_94144_(String value) {
        super.m_94144_(value);
        this.updateArrowsState();
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        boolean ret = super.m_5534_(typedChar, keyCode);
        this.updateArrowsState();
        return ret;
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        boolean ret = super.m_7933_(typedChar, keyCode, modifiers);
        this.updateArrowsState();
        return ret;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean ret = this.arrowUp.m_6375_(mouseX, mouseY, mouseButton) || this.arrowDown.m_6375_(mouseX, mouseY, mouseButton) || super.m_6375_(mouseX, mouseY, mouseButton);
        this.updateArrowsState();
        return ret;
    }

    protected void updateArrowsState() {
        if (this.arrows) {
            this.arrowDown.f_93623_ = true;
            this.arrowUp.f_93623_ = true;
            try {
                if (this.getInt() <= this.minValue) {
                    this.arrowDown.f_93623_ = false;
                }
                if (this.getInt() >= this.maxValue) {
                    this.arrowUp.f_93623_ = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

